k6 v0.33.0 is here! :tada: It's a small release that includes a bunch of minor bugfixes and enhancements, but is also laying the groundwork for some major new features like the upcoming `k6/execution` API in k6 v0.34.0.

## Acquired by Grafana Labs

Load Impact, the company behind k6, was acquired by Grafana Labs! :tada: Nothing changes regarding the k6 development for now, and any changes in the future will only be in the direction of accelerating our existing roadmap and plans, as well as better integration between k6 and the awesome Grafana tools. For more details, see the [official Grafana press release](https://grafana.com/about/press/2021-06-17-grafana-labs-brings-modern-open-source-load-testing-to-observability-with-acquisition-of-k6/).

## Enhancements and UX improvements

- The `--verbose` help message and the statsd warning message were improved ([#2005](https://github.com/k6io/k6/pull/2005)). Thanks, @vishalkuo!
- The `noColor` k6 option and the current UI state are now propagated to the [`handleSummary()` function](https://k6.io/docs/results-visualization/end-of-test-summary/#handlesummary-callback). The `state` object has the `isStdErrTTY`, `isStdOutTTY` and `testRunDurationMs` keys ([#1975](https://github.com/k6io/k6/pull/1975)).
- The error message when an HTTP request times out was improved (previously it was `context deadline exceeded`) and it now has an `error_code` value of `1050` ([#2008](https://github.com/k6io/k6/pull/2008)). Thanks, @vishalkuo!
- Script errors will no longer have the confusing `GoError` prefix in their error messages ([#1775](https://github.com/k6io/k6/pull/1775)).
- All [custom metric objects](https://k6.io/docs/javascript-api/k6-metrics/) now have a `name` property ([#2058](https://github.com/k6io/k6/pull/2058) and [#2076](https://github.com/k6io/k6/pull/2076)). Thanks, @olimpias and @david-gourde!
- Top-level JS arrays will now be properly encoded when sent in the body of a `application/x-www-form-urlencoded` request ([#2060](https://github.com/k6io/k6/pull/2060)). Thanks, @noelzubin!

## Bugs fixed!

- The [`minIterationDuration`](https://k6.io/docs/using-k6/options/#minimum-iteration-duration) option was uninterruptible and could delay the stopping of a scenario even after `gracefulStop` had expired. ([#2035](https://github.com/k6io/k6/pull/2035)).
- The `error_code` detection for HTTP/2, x509 and TLS (and potentially others) was unreliable ([#2025](https://github.com/k6io/k6/pull/2025)).
- k6 used to panic when `responseType` was `binary`, but there was no response body actually returned, e.g. when there was an HTTP error ([#2041](https://github.com/k6io/k6/pull/2041)).
- The [`throw` option](https://k6.io/docs/using-k6/options/#throw) was not respected when there was an invalid URL ([#2045](https://github.com/k6io/k6/pull/2045)). Thanks, @gchaincl!
- k6 would return an exit code of `103` instead of `107` for script errors when initializing non-service VUs ([#2046](https://github.com/k6io/k6/pull/2046)).
- Deleted library versions from cdnjs could previously cause a panic ([#2047](https://github.com/k6io/k6/pull/2047)).
- The correct error message for missing files was not shown when the filename contained spaces ([#1973](https://github.com/k6io/k6/pull/1973)).
- The regular expressions for the `github` and `cdnjs` "magic" loaders were slightly wrong ([#2066](https://github.com/k6io/k6/pull/2066)).
- A potential (harmless) data race could have been caused by an unintentional copying of a data struct ([#2067](https://github.com/k6io/k6/pull/2067)).
- The segmentation of small `ramping-arrival-rate` scenarios was not optimal ([#1863](https://github.com/k6io/k6/pull/1863#discussion_r655352623)).


## Internals

- The default end-of-test summary is now completely generated by the same [`k6-summary` JS code](https://jslib.k6.io/k6-summary/0.0.1/index.js) that is hosted on [jslib.k6.io](https://jslib.k6.io/) ([#1975](https://github.com/k6io/k6/pull/1975)). That PR also improved the k6 TTY detection and removed a few Go dependencies and code hacks, though it also caused us to bump the minimum required Go version for compiling k6 to Go 1.16 (because of its usage of [`go:embed`](https://golang.org/pkg/embed/)).
- Arrival-rate executors will no longer create a new goroutine for every new iteration ([#1957](https://github.com/k6io/k6/pull/1957) and [#2038](https://github.com/k6io/k6/pull/2038)).
- We have enabled GitHub's CodeQL checks for the Go parts of the repo ([#1961](https://github.com/k6io/k6/pull/1961)). Thanks, @jfcg!
- We have added the necessary k6 core changes for providing execution information to scripts [1863](https://github.com/k6io/k6/pull/1863))! This was the groundwork for the extended replacement of the [`__VU` and `__ITER` execution context variables](https://k6.io/docs/using-k6/execution-context-variables/) we plan to introduce. The new API will be able to return other information as well, for example which scenario the current iteration is in, what's the number of the current VU/iteration globally across all k6 instances, or in the current scenario, etc. These APIs are still not available to JS scripts, but we plan to expose them via the [`k6/x/execution` xk6 extension](https://github.com/k6io/xk6-execution) for now and iterate on them in the following weeks, releasing a stable version in k6 v0.34.0.


## Breaking changes

- The `k6 cloud` exit code for a failed cloud test was changed from `99` to `97` ([#2046](https://github.com/k6io/k6/pull/2046)).
- The default value of `K6_STATSD_TAG_BLOCKLIST` and `K6_DATADOG_TAG_BLACKLIST` is now `vu,iter,url` ([#2063](https://github.com/k6io/k6/pull/2063)).


